package com.example.imageview;

import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;

public class MainActivity extends AppCompatActivity {


    private ImageView image;
    private Button btn;
    private int [] imageIDs;
    private int currentImage = 0;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        image=(ImageView)findViewById(R.id.image);
        createImageIDs();
        updateUI();
        btn=(Button)findViewById(R.id.button);
        btn.setOnClickListener(new View.OnClickListener(){
            @Override
            public void onClick(View v) {
                updateUI();
            }
        });
    }
    private void updateUI(){
        image.setImageResource(imageIDs[currentImage++]);
        currentImage = currentImage % 9;
    }
    private void createImageIDs(){
        imageIDs = new int [9];
        imageIDs[0] = R.drawable.acdc;
        imageIDs[1] = R.drawable.foofighters;
        imageIDs[2] = R.drawable.metallica;
        imageIDs[3] = R.drawable.motorhead;
        imageIDs[4] = R.drawable.nigthwish;
        imageIDs[5] = R.drawable.ornatos;
        imageIDs[6] = R.drawable.greenday;
        imageIDs[7] = R.drawable.xutos;
        imageIDs[8] = R.drawable.taraperdida;
        currentImage = 0;
    }

}